package de.renew.net.inscription.transition;

import java.util.Collection;

import de.renew.engine.searcher.TriggerableCollection;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.unify.Variable;


class EnumeratorBinder extends AssignBinder {
    private final EnumeratorOccurrence _enumerator;

    EnumeratorBinder(EnumeratorOccurrence enumerator, boolean checkBound, Variable variable) {
        super(variable, checkBound);
        _enumerator = enumerator;
    }

    @Override
    public final void lock() {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
    }

    @Override
    public final void unlock() {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
    }

    @Override
    public Collection<?> getCandidates(Object pattern) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        return _enumerator.getCandidates(pattern);
    }

    @Override
    public TriggerableCollection getTriggerables() {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        return null;
    }
}