package de.renew.net.inscription.arc;

import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.TokenReserver;
import de.renew.unify.Variable;

/**
 * A TestArcBinder binds the variable inscribed on an Arc of the test type.
 */
class TestArcBinder extends ArcRemoveBinder {
    /**
     * Constructs a new TestArcBinder based on the inscribed variable and a place instance.
     *
     * @param variable the Variable of the test arc's inscription
     * @param placeInstance the SimulatablePlaceInstance that is tested for tokens
     */
    protected TestArcBinder(Variable variable, SimulatablePlaceInstance placeInstance) {
        super(variable, placeInstance);
    }

    @Override
    protected boolean mayBind() {
        return true;
    }

    @Override
    protected boolean possible(TokenReserver reserver, Object token) {
        return reserver.containsTestableToken(getPlaceInstance(), token);
    }

    @Override
    protected boolean remove(TokenReserver reserver, Object token) {
        return reserver.testToken(getPlaceInstance(), token);
    }

    @Override
    protected void unremove(TokenReserver reserver, Object token) {
        reserver.untestToken(getPlaceInstance(), token);
    }
}