/*
 * Created on Aug 3, 2004
 *
 */

package de.renew.net.inscription;

import java.util.Collection;

import de.renew.engine.searcher.Binder;
import de.renew.engine.searcher.Executable;
import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.OccurrenceDescription;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.VariableMapperCopier;
import de.renew.net.TransitionInstance;
import de.renew.unify.Impossible;


/**
 * Abstract occurrence class where new occurrence classes can be
 * derived from.
 *
 * @author Sven Offermann
 */
public abstract class AbstractOccurrence implements Occurrence {
    private final TransitionInstance _transitionInstance;

    /**
     * Creates a new Occurrence related to the given transition instance.
     *
     * @param transitionInstance
     *   the transition instance
     */
    protected AbstractOccurrence(TransitionInstance transitionInstance) {
        _transitionInstance = transitionInstance;
    }

    /**
     * @see de.renew.engine.searcher.Occurrence#getTransition()
     */
    @Override
    public TransitionInstance getTransition() {
        return _transitionInstance;
    }

    /**
     * @see de.renew.engine.searcher.Occurrence#makeBinders(de.renew.engine.searcher.Searcher)
     */
    @Override
    public abstract Collection<Binder> makeBinders(Searcher searcher) throws Impossible;

    /**
     * @see de.renew.engine.searcher.Occurrence#makeExecutables(de.renew.engine.searcher.VariableMapperCopier)
     */
    @Override
    public abstract Collection<Executable> makeExecutables(
        VariableMapperCopier variableMapperCopier);

    /**
     * @see de.renew.engine.searcher.Occurrence#makeOccurrenceDescription(de.renew.engine.searcher.VariableMapperCopier)
     */
    @Override
    public abstract OccurrenceDescription makeOccurrenceDescription(
        VariableMapperCopier variableMapperCopier);
}