package de.renew.net.event;

/**
 * A dummy implementation of the TransitionEventListener interface that does not do anything when firing starts or
 * ends. Its utility is unclear as it is unused.
 */
public class TransitionEventAdapter implements TransitionEventListener {
    private final boolean _wantSync;

    /**
     * Constructs a new TransitionEventAdapter with the given wantSync value.
     *
     * @param wantSync {@code true} if the notifications should be done synchronously,
     *                 {@code false} if they are done asynchronously.
     */
    public TransitionEventAdapter(boolean wantSync) {
        this._wantSync = wantSync;
    }

    @Override
    public boolean wantSynchronousNotification() {
        return _wantSync;
    }

    @Override
    public void firingStarted(FiringEvent fe) {}

    @Override
    public void firingComplete(FiringEvent fe) {}
}