package de.renew.net.event;

import de.renew.net.PlaceInstance;

/**
 * This event occurs when a single token (contained in the
 * event object) is put into the corresponding {@link PlaceInstance}.
 */
public class TokenEvent extends PlaceEvent {

    /** The token that has been added or removed. */
    private final Object _token;

    /**
     * Constructs a new TokenEvent using the given PlaceInstance
     * as the event source and the given token.
     *
     * @param instance the PlaceInstance as the event source
     * @param token the token that is in the PlaceInstance
     */
    public TokenEvent(PlaceInstance instance, Object token) {
        super(instance);
        _token = token;
    }

    /**
     * Returns the token that has been added or removed.
     *
     * @return the token that is in the PlaceInstance
     */
    public Object getToken() {
        return _token;
    }
}