package de.renew.net.event;

/**
 * An EventListener for events related to Places
 * and their marking.
 */
public interface PlaceEventListener extends NetEventListener {

    /**
     * This event method is called whenever the marking of
     * the corresponding PlaceInstance changes dramatically
     * (i.e. by more than one token).
     *
     * @param placeEvent the {@link PlaceEvent} that triggered the change
     */
    void markingChanged(PlaceEvent placeEvent);

    /**
     * This event occurs when a single token (contained in the
     * event object) is put into the corresponding PlaceInstance.
     *
     * @param tokenEvent the {@link TokenEvent} that triggered the change
     */
    void tokenAdded(TokenEvent tokenEvent);

    /**
     * This event occurs when a single token (contained in the
     * event object) is removed from the corresponding PlaceInstance.
     *
     * @param tokenEvent the {@link TokenEvent} that triggered the change
     */
    void tokenRemoved(TokenEvent tokenEvent);

    /**
     * This event occurs when a token (contained in the
     * event object) is tested within the corresponding PlaceInstance.
     *
     * @param tokenEvent the {@link TokenEvent} that triggered the change
     */
    void tokenTested(TokenEvent tokenEvent);

    /** This event occurs when a token (contained in the
     *  event object) is untested within the corresponding PlaceInstance.
     *
     * @param tokenEvent the {@link TokenEvent} that triggered the change
     */
    void tokenUntested(TokenEvent tokenEvent);
}