package de.renew.net.event;

/**
 * A standard implementation of the PlaceEventListener interface.
 */
public class PlaceEventAdapter implements PlaceEventListener {
    private final boolean _wantSync;

    /**
     * Constructs a new PlaceEventAdapter with the given wantSync value.
     *
     * @param wantSync true if the notifications should be done synchronously, false if they are done asynchronously
     */
    public PlaceEventAdapter(boolean wantSync) {
        _wantSync = wantSync;
    }

    @Override
    public boolean wantSynchronousNotification() {
        return _wantSync;
    }

    @Override
    public void markingChanged(PlaceEvent placeEvent) {}

    @Override
    public void tokenAdded(TokenEvent tokenEvent) {}

    @Override
    public void tokenRemoved(TokenEvent tokenEvent) {}

    @Override
    public void tokenTested(TokenEvent tokenEvent) {}

    @Override
    public void tokenUntested(TokenEvent tokenEvent) {}
}