package de.renew.net.event;

import de.renew.expression.VariableMapper;
import de.renew.net.TransitionInstance;


/**
 * This event occurs when a {@link TransitionInstance} starts a new
 * Occurrence or completes a running Occurrence.
 */
public class FiringEvent extends TransitionEvent {

    /** The variable binding of the Occurrence. */
    private final VariableMapper _mapper;

    /**
     * Constructs a new FiringEvent using the given {@code TransitionInstance} and the given
     * {@code VariableMapper}.
     *
     * @param instance the TransitionInstance used as the source of the event
     * @param mapper the VariableMapper for mapping local variables to their respective actual values
     */
    public FiringEvent(TransitionInstance instance, VariableMapper mapper) {
        super(instance);
        _mapper = mapper;
    }

    /**
     * Returns the variable mapper of the Occurrence.
     *
     * @return the VariableMapper
     */
    public VariableMapper getVariableMapper() {
        return _mapper;
    }
}