package de.renew.net;

import de.renew.engine.searcher.LateExecutable;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.net.event.FiringEvent;
import de.renew.simulatorontology.simulation.StepIdentifier;


/**
 * A {@code FiringCompleteExecutable} is an executable object that informs the {@link TransitionInstance}
 * of a {@link FiringEvent} that it has stopped firing.
 */
public class FiringCompleteExecutable implements LateExecutable {
    private final FiringEvent _event;

    FiringCompleteExecutable(FiringEvent event) {
        _event = event;
    }

    @Override
    public int phase() {
        return END;
    }

    @Override
    public boolean isLong() {
        return false;
    }

    @Override
    public void execute(StepIdentifier stepIdentifier) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        _event.getTransitionInstance().firingComplete(_event);
    }

    @Override
    public void executeAfterException(StepIdentifier stepIdentifier, Throwable t) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        // Proceed as normal.
        execute(stepIdentifier);
    }
}