package de.renew.engine.thread;

import de.renew.simulator.api.ISimulationLockExecutor;

/**
 * This class provides the global {@link ISimulationLockExecutor} implementation instance.
 */
public class SimulationLockExecutorProvider {
    private static final ISimulationLockExecutor SIMULATION_LOCK_EXECUTOR =
        new SimulationLockExecutorImpl();

    /**
     * Private, as no instances of this class should exist.
     */
    private SimulationLockExecutorProvider() {}

    /**
     * The provider method used by the {@link java.util.ServiceLoader}. Always returns the same instance.
     *
     * @return a instance of {@code IFinderRegistration}
     */
    public static ISimulationLockExecutor provider() {
        return SIMULATION_LOCK_EXECUTOR;
    }
}
