package de.renew.engine.simulator;

import de.renew.simulatorontology.simulation.Simulator;

/**
 * A NonConcurrentChildSimulator is a child simulator that does not
 * support concurrent execution of events. It extends the
 * AbstractConcurrentChildSimulator with the concurrency flag set to false.
 */
public class NonConcurrentChildSimulator extends AbstractConcurrentChildSimulator {
    /**
     * Constructs a NonConcurrentChildSimulator with the specified event queue delay
     * and parent simulator.
     *
     * @param wantEventQueueDelay whether the simulator will wait for the event queue before every firing
     * @param parentSimulator the parent {@link Simulator}
     */
    public NonConcurrentChildSimulator(boolean wantEventQueueDelay, Simulator parentSimulator) {
        super(wantEventQueueDelay, false, parentSimulator);
    }

    /**
     * Constructs a NonConcurrentChildSimulator with event queue delay enabled
     * and the specified parent simulator.
     *
     * @param parentSimulator the parent {@link Simulator}
     */
    public NonConcurrentChildSimulator(Simulator parentSimulator) {
        super(true, false, parentSimulator);
    }
}