package de.renew.engine.simulator;

import java.util.Properties;

import de.renew.simulatorontology.simulation.Simulator;


/**
 * An {@code ISimulatorFactory} is a factory that provides {@link Simulator} instances.
 */
public interface ISimulatorFactory {

    /**
     * Creates a new {@code Simulator} instance according to the given properties.
     * The properties will then be updated to reflect the chosen simulator class and multiplicity. A zero multiplicity denotes a
     * sequential simulator, which is minimally concurrent.
     * <p>
     * This method must be called from a simulation thread.
     *
     * @param properties the properties to use for determining the concrete {@code Simulator} class
     * @return a new {@code Simulator} instance
     */
    Simulator createSimulator(Properties properties);
}
