package de.renew.engine.simulator;

/**
 * This class extends the AbstractConcurrentSimulator and simulates a concurrent event.
 */
public class ConcurrentSimulator extends AbstractConcurrentSimulator {

    /**
     * Initializes a simulation for a concurrent event with the possibility
     * of waiting for the event queue before every firing.
     *
     * @param wantEventQueueDelay whether the simulator will wait for the event queue before every firing
     */
    public ConcurrentSimulator(boolean wantEventQueueDelay) {
        super(wantEventQueueDelay, true);
    }

    /**
     * Initializes a simulation for a concurrent event.
     */
    public ConcurrentSimulator() {
        super(true, true);
    }
}