package de.renew.engine.simulator;

import de.renew.engine.searcher.Finder;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.thread.SimulationThreadPool;

/**
 * A finder that checks whether the searcher it is informed about
 * is usable at the current simulation time.
 */
class CheckTimeFinder implements Finder {
    private final Finder _finder;

    CheckTimeFinder(Finder finder) {
        _finder = finder;
    }

    @Override
    public void found(Searcher searcher) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        // Only inform aggregated finder if searchable is usable now.
        if (searcher.getEarliestTime() <= SearchQueue.getTime()) {
            _finder.found(searcher);
        }
    }

    @Override
    public boolean isCompleted() {
        return _finder.isCompleted();
    }
}