package de.renew.engine.simulator;

import de.renew.simulatorontology.simulation.Simulator;
import de.renew.simulatorontology.simulation.StepIdentifier;

/**
 * Represents a specialized concurrent simulator that extends the functionality
 * of {@link AbstractConcurrentSimulator} by associating itself with a parent
 * {@link Simulator}.
 */
public class AbstractConcurrentChildSimulator extends AbstractConcurrentSimulator {
    private final Simulator _parentSimulator;

    /**
     * Initializes a new instance of {@link AbstractConcurrentChildSimulator} with the specified
     * configuration options and a reference to its parent {@link Simulator}.
     *
     * @param wantEventQueueDelay whether the simulator will wait for the event queue before every firing
     * @param wantConcurrentExecution whether the binding will be executed concurrently with the search process
     * @param parentSimulator the parent {@link Simulator}
     */
    public AbstractConcurrentChildSimulator(
        boolean wantEventQueueDelay, boolean wantConcurrentExecution, Simulator parentSimulator)
    {
        super(wantEventQueueDelay, wantConcurrentExecution);
        _parentSimulator = parentSimulator;
    }

    /**
     * Returns the parent {@link Simulator}.
     *
     * @return the parent {@link Simulator}
     */
    public Simulator getParentSimulator() {
        return _parentSimulator;
    }

    @Override
    public StepIdentifier nextStepIdentifier() {
        return getParentSimulator().nextStepIdentifier();
    }

    @Override
    public StepIdentifier currentStepIdentifier() {
        return getParentSimulator().currentStepIdentifier();
    }
}