package de.renew.engine.searchqueue;

import de.renew.engine.searcher.Searchable;

/**
 * A node in a random search queue.
 */
class RandomQueueNode {
    private final Searchable _searchable;

    RandomQueueNode(Searchable searchable) {
        _searchable = searchable;
    }

    /**
     * Returns the {@code Searchable} of the node.
     *
     * @return the {@code Searchable} of the node.
     */
    public Searchable getSearchable() {
        return _searchable;
    }
}