package de.renew.engine.searchqueue;

import de.renew.engine.thread.SimulationThreadPool;

/**
 * Initializes a {@link DeterministicSearchQueue} with a given time.
 */
public class DeterministicQueueFactory implements SearchQueueFactory {

    /**
     * Creates a new DeterministicQueueFactory.
     * The factory can only be used in a simulation thread.
     */
    public DeterministicQueueFactory() {
        super();
    }

    @Override
    public SearchQueueData makeQueue(double time) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        return new DeterministicSearchQueue(time);
    }
}