package de.renew.engine.searchqueue;

import de.renew.engine.searcher.Searchable;

/**
 * A node in a deterministic search queue (DSQ).
 */
class DSQListNode {
    private DSQListNode _previous;
    private DSQListNode _next;
    private final Searchable _elem;

    DSQListNode(Searchable elem) {
        _previous = this;
        _next = this;
        _elem = elem;
    }

    /**
     * Returns the previous node.
     *
     * @return the previous node
     */
    public DSQListNode getPrevious() {
        return _previous;
    }

    /**
     * Returns the next node.
     *
     * @return the next node
     */
    public DSQListNode getNext() {
        return _next;
    }

    /**
     * Sets the previous node to the given node.
     *
     * @param prev the node to be set as the previous node
     */
    public void setPrevious(DSQListNode prev) {
        _previous = prev;
    }

    /**
     * Sets the next node to the given node.
     *
     * @param next the node to be set as the next node
     */
    public void setNext(DSQListNode next) {
        _next = next;
    }

    /**
     * Returns the searchable element of this node.
     *
     * @return the searchable element of this node
     */
    public Searchable getElement() {
        return _elem;
    }
}