package de.renew.engine.searcher;

import de.renew.unify.Variable;

/**
 * An uplink provider is able to bind a channel to a searcher.
 * This is used to connect channels of subnets to the searcher
 * of the enclosing net.
 */
public interface UplinkProvider {
    /**
     * Binds a channel to a searcher.
     *
     * @param params the parameters of the channel
     * @param searcher the searcher to bind to
     */
    void bindChannel(Variable params, Searcher searcher);
}