/*
 * Created on 19.10.2004
 */

package de.renew.engine.events;

import de.renew.net.PlaceInstance;


/**
 * Untests a given token in a given {@link PlaceInstance}.
 *
 * @author Sven Offermann
 */
public class Untesting extends PlaceEvent {
    private final Object _token;

    /**
     * Initializes a {@link PlaceEvent} for a given {@link PlaceInstance}
     * and sets the token value for a given token.
     *
     * @param token the given value for the token
     * @param placeInstance the given {@link PlaceInstance} for the initialization of the {@link PlaceEvent}
     */
    public Untesting(Object token, PlaceInstance placeInstance) {
        super(placeInstance);

        _token = token;
    }

    @Override
    public String toString() {
        return "Untesting " + _token + " in " + getPlaceInstance();
    }

    /**
     * Returns the token that is untested in the place.
     *
     * @return the token
     */
    public Object getToken() {
        return _token;
    }
}