/*
 * Created on Nov 22, 2004
 *
 */

package de.renew.engine.events;

import java.io.PrintWriter;
import java.io.StringWriter;

import de.renew.net.TransitionInstance;


/**
 * Represents an exception, which occurs during a {@link TransitionInstance}.
 *
 * @author Sven Offermann
 */
public class TransitionException extends ExceptionEvent {
    private final TransitionInstance _transitionInstance;

    /**
     * Creates a new {@link TransitionException} without a specific
     * {@link TransitionInstance}.
     *
     * @param throwable the occurred exception
     */
    public TransitionException(Throwable throwable) {
        this(null, throwable);
    }

    /**
     * Creates a new {@link TransitionException} for a given {@link TransitionInstance}
     * and the occurred exception.
     *
     * @param transitionInstance the {@link TransitionInstance} this event is about
     * @param throwable the occurred exception
     */
    public TransitionException(TransitionInstance transitionInstance, Throwable throwable) {
        super(throwable);
        _transitionInstance = transitionInstance;
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);

        out.println("An exception occurred while firing transition " + _transitionInstance);
        getException().printStackTrace(out);

        return writer.toString();
    }

    /**
     * Returns the transition instance this exception is about.
     *
     * @return the transition instance
     */
    public TransitionInstance getTransitionInstance() {
        return _transitionInstance;
    }
}