/*
 * Created on 07.12.2004
 *
 */

package de.renew.engine.events;

import de.renew.net.TransitionInstance;


/**
 * Notifies the user that an event concerning a {@link TransitionInstance} has occurred.
 *
 * @author Sven Offermann
 */
public class TransitionEvent extends NetEvent {
    private final TransitionInstance _transitionInstance;

    /**
     * Creates a new {@link TransitionEvent} for a given {@link TransitionInstance}.
     *
     * @param transitionInstance the {@link TransitionInstance} this event is about
     */
    public TransitionEvent(TransitionInstance transitionInstance) {
        super(transitionInstance.getNetInstance());

        _transitionInstance = transitionInstance;
    }

    /**
     * Returns the {@link TransitionInstance} this event is about.
     *
     * @return the transition instance
     */
    public TransitionInstance getTransitionInstance() {
        return _transitionInstance;
    }
}