/*
 * Created on 19.10.2004
 */

package de.renew.engine.events;

import de.renew.net.PlaceInstance;


/**
 * Notifies the user that a token is put into a given {@link PlaceInstance}.
 *
 * @author Sven Offermann
 */
public class Putting extends PlaceEvent {
    private Double _time;
    private final Object _token;

    /**
     * Initializes a {@link PlaceEvent} for a given {@link PlaceInstance}
     * and sets the token value for a given token.
     *
     * @param token the given value for the token
     * @param placeInstance the given {@link PlaceInstance} for the initialization of the {@link PlaceEvent}
     * @param time the time when the token is put into the place
     */
    public Putting(Object token, PlaceInstance placeInstance, double time) {
        super(placeInstance);

        _token = token;
        _time = time;
    }

    /**
     * Initializes a {@link PlaceEvent} for a given {@link PlaceInstance}
     * and sets the token value for a given token.
     *
     * @param token the given value for the token
     * @param placeInstance the given {@link PlaceInstance} for the initialization of the {@link PlaceEvent}
     */
    public Putting(Object token, PlaceInstance placeInstance) {
        super(placeInstance);

        _token = token;
    }

    @Override
    public String toString() {
        return "Putting " + _token + " into " + getPlaceInstance();
    }

    /**
     * Returns the token that is put into the place.
     *
     * @return the token.
     */
    public Object getToken() {
        return _token;
    }

    /**
     * Returns the time or null if the time is not set.
     *
     * @return the time
     */
    public Double getTime() {
        return _time;
    }
}