/*
 * Created on 07.12.2004
 *
 */

package de.renew.engine.events;

import de.renew.net.PlaceInstance;


/**
 * Notifies the user that an event concerning a {@link PlaceInstance} has occurred.
 *
 * @author Sven Offermann
 */
public class PlaceEvent extends NetEvent {
    private final PlaceInstance _placeInstance;

    /**
     * Creates a new {@link PlaceEvent} for a given {@link PlaceInstance}.
     *
     * @param placeInstance the {@link PlaceInstance} this event is about
     */
    public PlaceEvent(PlaceInstance placeInstance) {
        super(placeInstance.getNetInstance());

        _placeInstance = placeInstance;
    }

    /**
     * Returns the {@link PlaceInstance} this event is about.
     *
     * @return the place instance.
     */
    public PlaceInstance getPlaceInstance() {
        return _placeInstance;
    }
}