/*
 * Created on Nov 22, 2004
 *
 */

package de.renew.engine.events;

import java.io.PrintWriter;
import java.io.StringWriter;

import de.renew.net.Net;


/**
 * Creates an exception, which occurs during the net instantiation.
 *
 * @author Sven Offermann
 */
public class NetInstantiationException extends ExceptionEvent {

    private final Net _net;

    /**
     * Creates a new {@link NetInstantiationException} for a given {@link Net}
     * and the exception that has occurred during the instantiation.
     *
     * @param net the {@link Net} this event is about
     * @param exception the occurred exception
     */
    public NetInstantiationException(Net net, Throwable exception) {
        super(exception);

        _net = net;
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);

        out.println("An exception occurred during the instantiation of net " + _net.getName());
        getException().printStackTrace(out);

        return writer.toString();
    }
}