/*
 * Created on 07.12.2004
 *
 */

package de.renew.engine.events;

import de.renew.engine.thread.SimulationThreadPool;
import de.renew.net.Net;
import de.renew.net.NetInstance;


/**
 * Notifies the user of any events concerning a {@link NetInstance}.
 *
 * @author Sven Offermann
 */
public abstract class NetEvent implements SimulationEvent {
    private final NetInstance _netInstance;

    /**
     * Creates a new {@link NetEvent} for a given {@link NetInstance}.
     *
     * @param net the {@link NetInstance} this event is about
     */
    public NetEvent(NetInstance net) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        _netInstance = net;
    }

    /**
     * Returns the {@link NetInstance} this event is about.
     *
     * @return the net instance
     */
    public NetInstance getNetInstance() {
        return _netInstance;
    }

    /**
     * Returns the {@link Net} this event is about.
     *
     * @return the net
     */
    public Net getNet() {
        return _netInstance.getNet();
    }
}