/*
 * Created on 19.10.2004
 */

package de.renew.engine.events;

import de.renew.net.PlaceInstance;


/**
 * An Inhibiting event indicates that a transition has fired
 * that would have been inhibited if a certain token had been
 * at a certain place.
 *
 * @author Sven Offermann
 */
public class Inhibiting extends PlaceEvent {
    private final Object _token;

    /**
     * Creates a new Inhibiting event for a given token
     * and place instance.
     *
     * @param token the given value for the token
     * @param placeInstance the given {@link PlaceInstance}
     */
    public Inhibiting(Object token, PlaceInstance placeInstance) {
        super(placeInstance);

        _token = token;
    }

    @Override
    public String toString() {
        return "Inhibiting " + _token + " at " + getPlaceInstance();
    }

    /**
     * Returns the token that is inhibiting at the place.
     *
     * @return the token
     */
    public Object getToken() {
        return _token;
    }
}