/*
 * Created on 14.09.2005
 *
 */

package de.renew.engine.events;

import de.renew.engine.thread.SimulationThreadPool;


/**
 * An ExceptionEvent informs the user that an exception has occurred.
 *
 * @author Sven Offermann
 */
public abstract class ExceptionEvent implements SimulationEvent {
    private final Throwable _throwable;

    /**
     * Creates a new {@link ExceptionEvent} for a given {@link Throwable}.
     *
     * @param throwable the {@link Throwable} this event is about
     */
    public ExceptionEvent(Throwable throwable) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        _throwable = throwable;
    }

    /**
     * Returns the {@link Throwable} this event is about.
     *
     * @return the throwable
     */
    public Throwable getException() {
        return _throwable;
    }
}