package de.renew.database;

import java.util.Hashtable;

import de.renew.net.NetInstance;


/**
 * This is a type safe wrapper around a hashtable.
 */
public class NetInstanceMap {
    private final Hashtable<String, NetInstance> _table = new Hashtable<>();

    /**
     * Puts a NetInstance into the map with its netID as the key.
     *
     * @param netID the ID of the net instance to be added
     * @param instance the NetInstance to be added to the map
     */
    public void put(String netID, NetInstance instance) {
        _table.put(netID, instance);
    }

    /**
     * Retrieves a NetInstance by its netID.
     *
     * @param netID the ID of the net instance to retrieve
     * @return the NetInstance associated with the given netID, or null if not found
     */
    public NetInstance get(String netID) {
        return _table.get(netID);
    }
}