package de.renew.database;

import de.renew.net.NetInstance;

/**
 * Represents an action that can be performed on a net instance.
 * This class encapsulates the net instance and provides methods to access its properties.
 */
public class NetAction {
    private final NetInstance _instance;

    /**
     * Constructs a NetAction with the specified net instance.
     *
     * @param instance the net instance associated with this action
     */
    public NetAction(NetInstance instance) {
        _instance = instance;
    }

    /**
     * Returns the net instance associated with this action.
     *
     * @return the net instance
     */
    public NetInstance getNetInstance() {
        return _instance;
    }

    /**
     * Returns the name of the net associated with this action.
     *
     * @return the name of the net
     */
    public String getName() {
        return _instance.getNet().getName();
    }

    /**
     * Returns the ID of the net instance associated with this action.
     *
     * @return the ID of the net instance
     */
    public String getNetID() {
        return _instance.getID();
    }
}