package de.renew.application;

import de.renew.simulator.api.ISimulatorExtensions;

/**
 * This class provides an implementation of {@link ISimulatorExtensions}.
 */
public final class SimulatorExtensionsProvider {
    private static final ISimulatorExtensions EXTENSIONS = new SimulatorExtensionsImpl();

    /**
     * The provider method used by the {@link java.util.ServiceLoader}. Always returns the same instance.
     *
     * @return an instance of {@code ISimulatorExtensions}
     */
    public static ISimulatorExtensions provider() {
        return EXTENSIONS;
    }

    private SimulatorExtensionsProvider() {}
}
