package de.renew.application;

import de.renew.database.SetupHelper.SimulationState;
import de.renew.simulatorontology.simulation.NoSimulationException;

/**
 * An {@code ISimulationStateRestorer} is responsible for restoring
 * the state of a simulation from the database if available.
 */
interface ISimulationStateRestorer {
    /**
     * If the corresponding properties have been set, the simulation will be
     * connected to a database engine and the last state from the database will
     * be restored. The net structures on which the state is based have to be
     * known before this method is called.
     * <p>
     * If the database properties are <i>not</i> set, this method will return
     * silently without modifying the simulation state. The return value will
     * then be the
     * {@link de.renew.database.SetupHelper.SimulationState#TERMINATED_STATE}
     * object. This object is also returned when the database connection failed.
     * If the database is configured correctly, the result will be an individual
     * state object, whether or not there was a state to restore.
     * </p>
     * <p>
     * If this method is called after the current simulation has already
     * performed some steps, i.e. created its own state, the result is
     * undefined.
     * </p>
     *
     * <p>
     * Access to this method is exclusive. The Java synchronized mechanism is
     * replaced by a specialized {@link de.renew.util.Lock#lock()}. How to achieve
     * synchronization across multiple methods is explained there.
     * </p>
     *
     * @return A {@code SimulationState} object describing the result of
     *         the operation (see comments above).
     * @throws NoSimulationException if there is no simulation set up.
     */
    SimulationState restoreStateFromDatabase();
}
