package de.renew.application;

import de.renew.simulator.api.IFinderRegistration;

/**
 * This class provides an implementation of {@link IFinderRegistration}.
 */
public final class FinderRegistrationProvider {
    private static final IFinderRegistration REGISTRATION = new FinderRegistrationImpl();

    /**
     * Private, as no instances of this class should exist.
     */
    private FinderRegistrationProvider() {}

    /**
     * The provider method used by the {@link java.util.ServiceLoader}. Always returns the same instance.
     *
     * @return a instance of {@code IFinderRegistration}
     */
    public static IFinderRegistration provider() {
        return REGISTRATION;
    }
}
