package de.renew.simulator.api;

/**
 * This class provides constants that represent the properties that can be set when using the simulator.
 */
public final class SimulatorPropertyConstants {

    private SimulatorPropertyConstants() {}

    /**
     * The name of the property to get the combined simulator mode from,
     * determining simulator class and multiplicity.
     */
    public static final String MODE_PROP_NAME = "de.renew.simulatorMode";

    /**
     * The name of the property to get the priority of the simulator thread
     */
    public static final String PRIORITY_PROP_NAME = "de.renew.simulatorPriority";

    /**
     * The name of the property to get the simulator multiplicity from.
     */
    public static final String MULTIPLICITY_PROP_NAME = "de.renew.simulatorMultiplicity";

    /**
     * The name of the property to get the simulator class name from.
     */
    public static final String CLASS_PROP_NAME = "de.renew.simulatorClass";

    /**
     * The name of the property to get the eager simulation flag from.
     */
    public static final String EAGER_PROP_NAME = "de.renew.eagerSimulation";

    /**
     * The name of the property to get the flag from that tells whether custom
     * classes should be reloaded every simulation run.
     */
    public static final String REINIT_PROP_NAME = "de.renew.classReinit";
}
