package de.renew.simulator.api;


import de.renew.simulatorontology.loading.Finder;
import de.renew.simulatorontology.loading.PathlessFinder;
import de.renew.simulatorontology.shadow.ShadowNetLoader;

/**
 * This interface offers methods to register and deregister {@link Finder} and {@link PathlessFinder} instances to the simulator.
 */
public interface IFinderRegistration {

    /**
     * Registers a finder for the default shadow net loader. Finders are without
     * effect if the default shadow net loader is overridden (either as plug-in
     * configuration or by an individual shadow net system).
     *
     * @param finder the shadow net file finder to add to the default shadow net
     *        loader.
     */
    void registerDefaultNetFinder(Finder finder);

    /**
     * Deregisters a finder from the default shadow net loader.
     *
     * @param finder the shadow net file finder to remove from the default shadow
     *        net loader.
     */
    void removeDefaultNetFinder(Finder finder);

    /**
     * Registers a pathless finder for the default shadow net loader. Finders
     * are without effect if the default shadow net loader is overridden (either
     * as plug-in configuration or by an individual shadow net system).
     *
     * @param finder the shadow net file finder to add to the default shadow net
     *        loader.
     */
    void registerDefaultPathlessFinder(PathlessFinder finder);

    /**
     * Deregisters a pathless finder from the default shadow net loader.
     * 
     * @param finder the shadow net file finder to remove from the default shadow
     *        net loader.
     */
    void removeDefaultPathlessFinder(PathlessFinder finder);

    /**
     * Sets the current {@code ShadowNetLoader}.
     *
     * @param netLoader the {@code ShadowNetLoader} to set
     */
    void setNetLoader(ShadowNetLoader netLoader);

    /**
     * Returns the currently configured {@code ShadowNetLoader}.
     *
     * @return the currently configured {@code ShadowNetLoader}
     */
    ShadowNetLoader getNetLoader();
}
