package de.renew.refactoring.search.range;

import java.util.Collections;
import java.util.Iterator;

import de.renew.draw.storables.ontology.Drawing;


/**
 * Drawing search range that finds only one specified drawing.
 *
 * @author 2mfriedr
 */
public class SingleDrawingSearchRange implements DrawingSearchRange {
    private static final org.apache.log4j.Logger LOGGER =
        org.apache.log4j.Logger.getLogger(SingleDrawingSearchRange.class);
    private final Iterator<Drawing> _drawings;

    /**
     * Constructs a single drawing search range.
     *
     * @param drawing the drawing
     */
    public SingleDrawingSearchRange(final Drawing drawing) {
        _drawings = Collections.singletonList(drawing).iterator();
    }

    @Override
    public String description() {
        return "Current drawing";
    }

    @Override
    public int numberOfDrawings() {
        return 1;
    }

    @Override
    public Iterator<Drawing> drawings() {
        return _drawings;
    }
}