package de.renew.refactoring.parse.name;

import java.util.Collections;
import java.util.List;

import de.renew.refactoring.match.StringMatch;


/**
 * Convenience name finder implementation that returns {@code false} on {@link
 * NameFinder#find(String)} and an empty list on {@link
 * NameFinder#listOfMatches(String)}.
 *
 * @author 2mfriedr
 */
public class NoNameFinder implements NameFinder {
    private static final org.apache.log4j.Logger LOGGER =
        org.apache.log4j.Logger.getLogger(NoNameFinder.class);

    @Override
    public boolean find(String input) {
        return false;
    }

    @Override
    public List<StringMatch> listOfMatches(String input) {
        return Collections.emptyList();
    }
}