package de.renew.propertymanagementgui.gui;

import javax.swing.JButton;
import javax.swing.JComponent;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;


/**
 * Unit test class for SaveButtonComponent
 *
 * @author 7kraft
 */
class SaveButtonComponentTest {

    @Test
    public void testRender() {
        //given
        Runnable action = Mockito.mock(Runnable.class);
        String label = "Save globally";

        SaveButtonComponent comp = new SaveButtonComponent(action, label);

        //when
        JComponent component = comp.render();

        //then
        Assertions.assertThat(component).isNotNull();
        Assertions.assertThat(component).isInstanceOf(JButton.class);

        //when
        JButton btn = (JButton) component;

        //then
        Assertions.assertThat(btn.getText()).isEqualTo(label);
        Assertions.assertThat(btn.getActionListeners().length).isEqualTo(1);

        //when
        btn.doClick();

        //then
        Mockito.verify(action).run();
    }
}