package de.renew.propertymanagementgui.commands;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.MockedConstruction;
import org.mockito.Mockito;

import de.renew.propertymanagementgui.controller.SettingsController;

import static org.assertj.core.api.Assertions.assertThat;

/**
 * Unit test class for OpenSettingsWindowCommand
 *
 * @author 7kraft
 */
class OpenSettingsWindowCommandTest {

    @Test
    public void testExecute() {
        //given
        OpenSettingsWindowCommand cmd = new OpenSettingsWindowCommand();

        try (MockedConstruction<SettingsController> mocked =
            Mockito.mockConstruction(SettingsController.class)) {

            //when
            cmd.execute();

            //then
            Assertions.assertThat(mocked.constructed().size()).isEqualTo(1);
            SettingsController controller = mocked.constructed().get(0);
            Mockito.verify(controller).openSettingsWindow();
            Mockito.verifyNoMoreInteractions(controller);
        }
    }

    @Test
    public void testIsExecutable() {
        OpenSettingsWindowCommand cmd = new OpenSettingsWindowCommand();
        assertThat(cmd.isExecutable()).isTrue();
    }
}