package de.renew.propertymanagementgui.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import de.renew.propertymanagementgui.reactivecomponents.Component;


/**
 * This class represents the side navigation items component of the settings window.
 * It is responsible for rendering a list of navigation items, where each item is a {@link PluginNavigationComponent}.
 * Each navigation item represents a plugin and is associated with a {@link Runnable} action that is executed when the item is clicked.
 */
public class SideNavItemsComponent extends Component {
    private static final Color BACKGROUND_COLOR_WHITE = new Color(238, 238, 238);
    private static final int SIDE_NAV_ITEMS_WIDTH = 200;

    private final Map<String, Runnable> _navEntries;

    /**
     * Creates a new SideNavItemsComponent.
     *
     * @param navEntries The entries of the navigation items to be displayed.
     */
    protected SideNavItemsComponent(Map<String, Runnable> navEntries) {
        _navEntries = navEntries;
    }

    @Override
    protected JComponent render() {
        int windowHeight = 0;
        JComponent sideNavItems = new JPanel();
        sideNavItems.setLayout(new BoxLayout(sideNavItems, BoxLayout.Y_AXIS));

        for (Map.Entry<String, Runnable> entry : _navEntries.entrySet()) {
            PluginNavigationComponent temporaryComponent =
                new PluginNavigationComponent(entry.getKey(), entry.getValue());
            sideNavItems.add(temporaryComponent.get());
            windowHeight += 20;
        }
        sideNavItems.setBackground(BACKGROUND_COLOR_WHITE);
        sideNavItems.setPreferredSize(new Dimension(SIDE_NAV_ITEMS_WIDTH, windowHeight));

        JScrollPane scrollPane = new JScrollPane(sideNavItems);
        scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);

        return scrollPane;
    }

}
