package de.renew.propertymanagementgui.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

import de.renew.propertymanagementgui.reactivecomponents.Component;


/**
 * The footer of the settings window. Embeds the action Save and Cancel button.
 */
public class FooterComponent extends Component {

    private static final String SAVE_LOCALLY = "Save locally";
    private static final String SAVE_GLOBALLY = "Save globally";
    private static final int RIGID_AREA_WIDTH = 10;
    private static final int RIGID_AREA_HEIGHT = 0;
    private static final EmptyBorder ACTION_BUTTONS_WRAPPER_BORDER = new EmptyBorder(5, 5, 5, 5);

    private final Runnable _savePropertiesGlobalAction;
    private final Runnable _savePropertiesLocalAction;

    /**
     * Creates a new FooterComponent.
     *
     * @param savePropertiesGlobalAction The action to be performed when the save globally button is clicked.
     * @param savePropertiesLocalAction The action to be performed when the save locally button is clicked.
     */
    public FooterComponent(
        Runnable savePropertiesGlobalAction, Runnable savePropertiesLocalAction)
    {
        _savePropertiesGlobalAction = savePropertiesGlobalAction;
        _savePropertiesLocalAction = savePropertiesLocalAction;
    }

    @Override
    protected JComponent render() {
        JComponent footer = new JPanel();
        setLayoutForFooter(footer);

        JComponent actionButtonsWrapper = getActionButtonsWrapperIn();
        footer.add(actionButtonsWrapper, BorderLayout.EAST);

        return footer;
    }

    private void setLayoutForFooter(JComponent footer) {
        footer.setMaximumSize(new Dimension(Integer.MAX_VALUE, footer.getPreferredSize().height));
        footer.setLayout(new BorderLayout());
    }

    private JComponent getActionButtonsWrapperIn() {
        JPanel actionButtonsWrapper = new JPanel();
        setLayoutForActionButtonsWrapper(actionButtonsWrapper);

        addActionButtonsToActionButtonsWrapper(actionButtonsWrapper);

        return actionButtonsWrapper;
    }

    private void setLayoutForActionButtonsWrapper(JComponent actionButtonsWrapper) {
        actionButtonsWrapper.setLayout(new BoxLayout(actionButtonsWrapper, BoxLayout.X_AXIS));
        actionButtonsWrapper.setBorder(ACTION_BUTTONS_WRAPPER_BORDER);
    }

    private void addActionButtonsToActionButtonsWrapper(JComponent actionButtonsWrapper) {
        Component saveButtonLocal =
            new SaveButtonComponent(_savePropertiesLocalAction, SAVE_LOCALLY);
        Component saveButtonGlobal =
            new SaveButtonComponent(_savePropertiesGlobalAction, SAVE_GLOBALLY);
        actionButtonsWrapper.add(saveButtonLocal.get());
        actionButtonsWrapper.add(saveButtonGlobal.get());

        actionButtonsWrapper
            .add(Box.createRigidArea(new Dimension(RIGID_AREA_WIDTH, RIGID_AREA_HEIGHT)));

        Component closeButton = new CloseButtonComponent(e -> {
            // Get the window that contains the button
            Window window = SwingUtilities.getWindowAncestor(actionButtonsWrapper);
            // Close the window
            if (window != null) {
                window.dispose();
            }
        });
        actionButtonsWrapper.add(closeButton.get());
    }
}
