package de.renew.propertymanagementgui;

import java.awt.event.KeyEvent;
import java.net.URL;
import javax.swing.KeyStroke;

import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.CommandMenuItem;
import de.renew.draw.ui.api.MenuApi;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginProperties;
import de.renew.propertymanagement.prop.ConfigurablePropertyManager;
import de.renew.propertymanagementgui.commands.OpenSettingsWindowCommand;

/**
 * Main class of the PropertyManagementGUI plugin that registers the GUI in the Renew menu.
 * This GUI can be used to configure properties.
 * @author 0schult
 */
public class PropertyManagementGUIPlugin extends PluginAdapter {
    private CommandMenu _menu;
    private CommandMenuItem _openSettingsMenuItem;

    /**
     * Creates an instance of the PropertyManagementGUI Plugin using the contents of <code>plugin.cfg</code>.
     *
     * @param location a <code>URL</code> pointing to the <code>jar</code>
     *                 file or directory containing the plugin code and
     *                 configuration files.
     * @throws PluginException if an error occurs while loading the plugin or its configuration.
     *                         Possible nested exceptions are:
     *                         <ul>
     *                         <li>{@link java.net.MalformedURLException} if the <code>plugin.cfg</code> URL
     *                             could not be derived from the plugin URL.</li>
     *                         <li>{@link java.io.IOException} if the configuration could not be loaded.</li>
     *                         </ul>
     */
    public PropertyManagementGUIPlugin(URL location) throws PluginException {
        super(location);
    }

    /**
     * Creates the PluginManagementGUI Plugin with the given PluginProperties.
     *
     * @param props the plugin configuration.
     */
    public PropertyManagementGUIPlugin(PluginProperties props) {
        super(props);
    }

    /** 
     * Initialize the plugin, register menus and commands.
     * {@link de.renew.plugin.PluginAdapter#init()}
     */
    @Override
    public void init() {
        _openSettingsMenuItem = new CommandMenuItem(new OpenSettingsWindowCommand());
        _openSettingsMenuItem
            .putClientProperty(MenuApi.ID_PROPERTY, "de.renew.gui.propertymanagementgui");
        MenuApi.registerMenu(MenuApi.getMenuNamePluginsMenu(), _openSettingsMenuItem);
        //non-functional hotkey for testing/demonstration purposes
        KeyStroke k1 = KeyStroke.getKeyStroke(KeyEvent.VK_K, KeyEvent.CTRL_DOWN_MASK);
        KeyStroke k2 = KeyStroke.getKeyStroke(KeyEvent.VK_L, KeyEvent.CTRL_DOWN_MASK);
        ConfigurablePropertyManager.getInstance().addConfigurableHotkeyProperty(
            "Sample Hotkey", k1, "PropertyManagementGUI", "Sample Hotkey");
        ConfigurablePropertyManager.getInstance().addConfigurableHotkeyProperty(
            "Sample Hotkey 2", k2, "PropertyManagementGUI", "Sample Hotkey 2");

    }

    /** 
     * Unregisters menus and (possible) commands.
     * {@link de.renew.plugin.PluginAdapter#init()}
     */
    @Override
    public boolean cleanup() {
        MenuApi.unregisterMenu(_openSettingsMenuItem);
        ConfigurablePropertyManager.getInstance().removeConfigurableProperty("Sample Hotkey");
        ConfigurablePropertyManager.getInstance().removeConfigurableProperty("Sample Hotkey 2");

        return true;
    }
}
