package de.renew.propertymanagement.prop;


/**
 * The PropertyChangeListener interface provides a contract for classes that wish to be notified
 * of changes to configurable properties in the {@link ConfigurablePropertyManager}.
 */
public interface PropertyChangeListener {

    /**
     * Invoked when a configurable property has been changed.
     *
     * @param event The PropertyChangeEvent object describing the change.
     */
    void propertyChanged(PropertyChangeEvent event);

    /**
     * Invoked when a new configurable property has been added.
     *
     * @param event The PropertyChangeEvent object describing the addition.
     */
    void propertyAdded(PropertyChangeEvent event);

    /**
     * Invoked when an existing configurable property has been removed.
     *
     * @param event The PropertyChangeEvent object describing the removal.
     */
    void propertyRemoved(PropertyChangeEvent event);
}
