package de.renew.propertymanagement.commands;

import java.io.PrintStream;

import de.renew.plugin.command.CLCommand;
import de.renew.propertymanagement.prop.ConfigurableProperty;
import de.renew.propertymanagement.prop.ConfigurablePropertyManager;


/**
 * This command is used to show all configurable properties.
 *
 * @author Olga Oloventseva; Marvin Brendel
 */
public class GetConfigurablePropertiesCommand implements CLCommand {
    /**
     * The String identifying the command in the command line
     */
    public static final String COMMAND_NAME = "listConfigurableProperties";

    /**
     * Default constructor for {@link GetConfigurablePropertiesCommand}.
     */
    public GetConfigurablePropertiesCommand() {}

    @Override
    public void execute(String[] args, PrintStream response) {
        var configurableProperties =
            ConfigurablePropertyManager.getInstance().getConfigurableProperties();
        configurableProperties.values().forEach(
            configurableProperty -> showConfigurableProperty(configurableProperty, response));
    }

    /**
     * Prints a key and a display name of the property.
     * @param configurableProperty Configurable Property.
     * @param response  The <code>PrintStream</code> for user feedback.
     */
    private void showConfigurableProperty(
        ConfigurableProperty configurableProperty, PrintStream response)
    {
        response.println(
            configurableProperty.getKey() + " (" + configurableProperty.getDisplayName() + ")");
    }

    @Override
    public String getDescription() {
        return "Returns a list of all configurable properties.";
    }

    @Override
    public String getArguments() {
        return "";
    }
}
