# PropertyManagement

## User Guide

_PropertyManagement_ adds a centralized interface for other Plugins to add configurable properties to Renew.

### Features

- Register configurable properties
- Read existing configurable properties
- Update configurable properties at runtime without having to restart Renew
  - Some exceptions apply, e.g. system properties like the Swing GUI-Scale

### Example Usage

1. Register a configurable property at the ConfigurablePropertiesManager
2. Configure the property in the configuration file (.renew.properties), usually found in the users home directory
3. The configure property should now be loaded when Renew is started

### Provided Commands

- `GetConfigurableProperties` - Lists all configurable properties

### Installation

Install _PropertyManagement_ by putting the JAR file inside the `dist/plugins` directory.
As PropertyManagement is a core plugin with a lot of other plugins depending on it,
this step should not be necessary.

It will be automatically loaded at startup of Renew - see below for more configuration options.

### Dependencies

This plugin depends on the following plugins and external libraries:

- `Loader`: (mandated)

### Configuration

During the initialization of PropertyManagement, all existing properties are read from the `renew.properties` file
located in the Renew config directory,
or the users "home" directory.
Currently, PropertyManagement itself does not have any configurable properties.

[//]: # (**NAME**|**TYPE**|**DESCRIPTION**|**DEFAULT**)

[//]: # (:-----|:-----:|:-----|:-----)

[//]: # (`de.renew.sampleplugin.workspace`|String|Specifies the path to your workspace, i.e.: `/path/to/your/desired/dir`.|`/Renew`)

[//]: # (`de.renew.sampleplugin.showToolsAtStartup`|boolean|Load the drawing tools at startup.| true)

## Developer Guide

### Core Classes

- `PropertyManagementPlugin`: Implements the `IPlugin` interface to manage the startup and shutdown
- `ConfigurablePropertyManager`: The main interface to register configurable properties
- `PropertyChangeEvent`: Event that occurs when any property is changed
- `PropertyChangeListener`: Interface for a listener that is notified for every `PropertyChangeEvent`
- `ConfigurableProperty`: Represents a single configurable property with its default and current values

### How to Extend

Register a `ConfigurableProperty` or a `PropertyChangeListener` to interact with this Plugin.
As this Plugin is one of the first plugins to be loaded, you can also register Java system properties.

The main class to register properties is the `ConfigurablePropertyManager`. Accessible as a singleton,
you can register a property using the `addConfigurableProperty` method, or likewise remove it using `removeConfigurableProperty`.

Currently, the best example for usage of configurable properties is the `Rewew FA` plugin. It registers a handful of different
properties in the `init` method of the `FAPlugn` class.

### Additional Information
