package de.renew.plugindevelopment.generating;

import java.io.File;
import java.util.Properties;

import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

/**
 * The LibraryPluginGenerator class extends StandardPluginGenerator and generates a (Renew) plugin
 * files for a plugin based on predefined templates. Includes build.gradle, gradle.properties, plugin.cfg,
 * module-info.java, README.md.
 *
 * @author Haustermann
 */
public class LibraryPluginGenerator extends StandardPluginGenerator {
    private static String _libraryTemplateFolder = "/templates/library/";
    private static final String PLUGIN_PATH = "src/main/java/";

    /**
     * Constructs a LibraryPluginGenerator. Sets the predefined library template to be
     * the template folder.
     */
    public LibraryPluginGenerator() {
        super();
        this._templateFolder = _libraryTemplateFolder;
    }

    /**
     * Creates the files necessary to create a plugin from the given templates.
     *
     * @param props The properties containing the pluginname
     * @param rootDir The plugins root directory
     */
    @Override
    protected void createFilesFromTemplates(String rootDir, Properties props) {
        try {
            Context context;
            context = getContextFromProperties(props);
            context
                .put("generic-description", "This is the generated desctiption for this plugin.");
            context.put("generic-name", props.getProperty("appName").toLowerCase());
            context.put("smallAppName", props.getProperty("appName").toLowerCase());

            // copy the build.gradle file
            createFile(_ve, context, rootDir, "", "build.gradle", null);

            // copy the gradle.properties file
            createFile(_ve, context, rootDir, "", "gradle.properties", null);

            // copy the module-info.java file
            createFile(
                _ve, context, rootDir,
                "src/main/java/de.renew." + props.getProperty("appName").toLowerCase(),
                "module-info.java", null);

            // copy the plugin.cfg file
            createFile(_ve, context, rootDir, "src/main/resources", "plugin.cfg", null);

            // copy the README.md file
            createFile(_ve, context, rootDir, "", "README.md", null);

        } catch (ResourceNotFoundException e) {
            _logger.error(e.getMessage());
            _logger.debug(e.getStackTrace());
        } catch (ParseErrorException e) {
            _logger.error(e.getMessage());
            _logger.debug(e.getStackTrace());
        } catch (Exception e) {
            _logger.error(e.getMessage());
            _logger.debug(e.getStackTrace());
        }
    }

    @Override
    protected void createFolders(String rootDir, String appName) {
        File directory = new File(
            rootDir + File.separator + appName + File.separator + PLUGIN_PATH + File.separator
                + "de.renew." + appName.toLowerCase() + File.separator + "de" + File.separator
                + "renew" + File.separator + appName.toLowerCase());
        directory.mkdirs();


    }
}