# PluginDevelopment

## User Guide

_PluginDevelopment_ is responsible for the creation of new plugins in Renew. It ensures compliance
with the conventions.

### Features

Menu Command extends Plugin menu by entry
Plugin Development >> Create Renew Plugin Folder

### Example Usage

1. Create a new text file "name.plg" (properties-like file) and save it at any place you want and
   remember  
   1.1 add the entry (key value) "appName = <YourPluginName>" to the newly created file and save it

2. Start Renew (did you run the Renew build process before? yes? nice!) at commandline by
   calling: >> java -jar loader.jar gui

3. If Renew has successfully been started, go to:  
   3.1 Menu > Plugin > PluginDevelopment >> Create Renew Plugin Folder
   -> A file chooser menu will be opened  
   3.2 Choose/search your "name.plg" file which you created at step 1. and confirm
   -> Another file chooser menu will be opened  
   3.3 Select Renew Plugin Source Folder  
   3.3.1 If you want to create a new Renew plugin choose <path/to/Renew>/Renew  
   3.3.2 If you want to create a new Mulan plugin choose <path/to/Mulan>/Mulan

4. If you were able to proceed until here, you will get the following:

- src/main/java folder
- README.md
- resources/plugin.cfg
- build.gradle
- module-info.java  
  at the <location given at step 3.3>/appName

5. Any problems? Call our help desk in Bavaria or support@renew.de

### Provided Commands

- `de.renew.plugindevelopment.commands.CreateApplicationStructureCommand`
- Calls the generator for an uc diagram.

### Included Packages

- `de.renew.plugindevelopment`
- Used to generate modular Renew plugins built with gradle

### Public Interfaces

- `de.renew.plugindevelopment.generating.PluginGenerator`
