package de.renew.ptchannel;

import java.net.URL;

import de.renew.formalism.FormalismPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginProperties;
import de.renew.ptchannel.nin.PTNetInNetCompiler;
import de.renew.ptchannel.single.PTNetWithChannelCompiler;

/**
 * Representative for the PTChannel plugin.
 *
 * @author Lukas Voß
 */
public class PTChannelPlugin extends PluginAdapter {

    /**
     * The name of a single P/T net with a channel compiler.
     */
    public static final String PT_CHANNEL = "Single P/T Net with Channel Compiler";

    /**
     *  The name of a P/T net with an in net compiler.
     */
    public static final String PT_NIN = "P/T Net in Net Compiler";

    /**
     * Constructor for the plugin to create an instance of the plugin using the plugin url.
     *
     * @param url The URL of the plugin.
     * @throws PluginException If an error occurs during plugin initialization.
     */
    public PTChannelPlugin(URL url) throws PluginException {
        super(url);
    }

    /**
     * Constructor for the plugin to create an instance of the plugin using the properties.
     *
     * @param props The properties of the plugin.
     */
    public PTChannelPlugin(PluginProperties props) {
        super(props);
    }

    /**
     * Initialize the plugin, register menus and commands.
     *
     * @see de.renew.plugin.PluginAdapter#init()
     */
    @Override
    public void init() {
        FormalismPlugin.getCurrent().addCompilerFactory(PT_CHANNEL, new PTNetWithChannelCompiler());
        FormalismPlugin.getCurrent().addCompilerFactory(PT_NIN, new PTNetInNetCompiler());
    }

    /**
     * Deinitialize plugin.
     *
     * @see de.renew.plugin.PluginAdapter#cleanup()
     */
    @Override
    public boolean cleanup() {
        return super.cleanup();
    }
}