package de.renew.netcomponents;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;
import static org.mockito.Mockito.doReturn;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.spy;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;

/**
 * This class is a test class for {@link RemoveToolsWindow}.
 */
public class RemoveToolsWindowTest {

    private RemoveToolsWindow _testToolsWindow;
    private RemoveToolsControl _testControl;
    private Vector<ComponentsTool> _testV;
    @Mock
    private ComponentsTool _testCompTool1;
    @Mock
    private ComponentsTool _testCompTool2;
    @Mock
    private ComponentsToolPlugin _componentsToolPluginTest;

    /**
     * Creates an object of {@link RemoveToolsControl}, {@link RemoveToolsWindow} and their intern vector v.
     */
    @BeforeEach
    public void setUp() {
        _testCompTool1 = mock(ComponentsTool.class);
        _testCompTool2 = mock(ComponentsTool.class);
        _componentsToolPluginTest = mock(ComponentsToolPlugin.class);

        _testV = new Vector<>();
        _testV.add(_testCompTool1);
        _testV.add(_testCompTool2);
        doReturn(_testV).when(_componentsToolPluginTest).getCTList();

        _testControl = spy(new RemoveToolsControl(_componentsToolPluginTest));
        _testToolsWindow = spy(new RemoveToolsWindow(_testV, _testControl));
    }

    /**
     * Tests the method {@link RemoveToolsWindow#removeComponentsTools(List)}.
     * Tests if the list to remove is passed to the intern {@link RemoveToolsControl} and removes the content there.
     */
    @Test
    public void removeComponentsToolsTest() {
        // in the beginning the list should be as initialized
        assertEquals(_testV, _testControl.getV());
        assertEquals(2, _testControl.getV().size());

        // an empty list is not passed so removeFromList should not be called on testControl.
        ArrayList<ComponentsTool> emptyList = new ArrayList<>();
        _testToolsWindow.removeComponentsTools(emptyList);
        verify(_testControl, times(0)).removeFromList(emptyList);
        assertEquals(_testV, _testControl.getV());

        // when the list contains an element of the intern list it should be removed
        List<ComponentsTool> testList = new ArrayList<>();
        testList.add(_testCompTool1);
        _testToolsWindow.removeComponentsTools(testList);
        verify(_testControl, times(1)).removeFromList(testList);
        assertFalse(_testControl.getV().contains(_testCompTool1));
        assertTrue(_testControl.getV().contains(_testCompTool2));
        assertEquals(1, _testControl.getV().size());
    }

}