package de.renew.netcomponents;

import java.util.Collection;
import java.util.Vector;

import org.junit.jupiter.api.Test;

import de.renew.draw.storables.ontology.Figure;
import de.renew.gui.CPNTextFigure;

import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;

/**
 * @author 1schende
 */
class NetComponentFigureTest {
    @Test
    public void testGroup() {
        //given
        final NetComponentFigure figure1 = new NetComponentFigure();
        final Figure figure2 = new CPNTextFigure();
        final Figure figure3 = new CPNTextFigure();
        final Figure figure4 = new CPNTextFigure();
        final Collection<Figure> collection1 = new Vector<>();

        collection1.add(figure2);
        collection1.add(figure3);
        //when
        figure1.group(collection1);
        //then
        assertTrue(figure1.getAttached().contains(figure2));
        assertTrue(figure1.getAttached().contains(figure3));
        assertFalse(figure1.getAttached().contains(figure4));
    }

    @Test
    public void testAttach() {
        //given
        final NetComponentFigure figure1 = new NetComponentFigure();
        final Figure figure2 = new CPNTextFigure();
        final Figure figure3 = new CPNTextFigure();
        //when
        figure1.attach(figure2);
        //then
        assertTrue(figure1.getAttached().contains(figure2));
        assertFalse(figure1.getAttached().contains(figure3));
    }

    @Test
    public void testReleaseFigures() {
        //given
        final NetComponentFigure figure1 = new NetComponentFigure();
        final Figure figure2 = new CPNTextFigure();
        final Collection<Figure> collection1 = new Vector<>();
        collection1.add(figure2);
        figure1.group(collection1);
        //when
        figure1.releaseFigures(collection1);
        //then
        assertTrue(figure1.getAttached().isEmpty());
    }

    public void testReleaseFiguresEmptyCollection() {
        //given
        final NetComponentFigure figure1 = new NetComponentFigure();
        final Collection<Figure> collection1 = new Vector<>();
        //when
        figure1.releaseFigures(collection1);
        //then
        assertTrue(figure1.getAttached().isEmpty());
    }
}